
/*** Change the Current directory ***/
cd "D:\Marc\2 MAFE\MISE A DISPOSITION\tutoriel\stata_tuto"

********************
* ANALYSIS DATASET *
********************

/* person year database for each year of life with general.dta*/

use "general.dta", clear	
generate a2008=2008
generate dur=(a2008-q1a)+1
expand dur
bysort ident: generate year=q1a+_n-1
bysort ident: generate age=_n-1
label variable year "Year"
label variable age "Age"
save "year.dta"

/* person year database for each year of migration */
use "migration.dta", clear
drop if num_mig==.
generate end_08=1 if  q601f==2008
replace q601f=2007 if q601f==2008
recode q601f .=2008
expand (q601f-q601d+1)
bysort ident num_mig: generate year=q601d+_n-1
drop if (q601f==year) & year!=2008 & end_08!=1
drop end_08
sort ident year
save "loc_resp.dta"

/* merge loc_resp.dta & year.dta  */
use "year.dta"
sort ident year
merge 1:1 ident year using "loc_resp.dta"
drop _merge
rename q602 loc_resp
recode loc_resp (.=99341) /*99341 = code for Senegal*/
keep ident year age loc_resp
save "loc_resp.dta", replace

/* person year database for each year of migration (partners)*/
use "network.dta", clear
keep if q901==1
generate end_08=1 if  q904f==2008
replace q904f=2007 if q904f==2008
replace q904f=2008 if q904f==.
expand (q904f-q904d+1)
bysort id_uni num_netmig: generate year=q904d+_n-1
drop if (q904f==year) & year!=2008 & end_08!=1
keep ident id_uni country q904d q904f year
sort id_uni year 
save "net_conj.dta", replace


/* person year database for union.dta & merge with net_conj.dta*/
use "union.dta", clear
generate end_08=1 if  q102f==2008		
replace q102f=2007 if q102f==2008
replace q102f=2008 if q102f==.
expand (q102f-q102d+1)
bysort ident num_uni: generate year=q102d+_n-1
drop if (q102f==year) & year!=2008 & end_08!=1
keep ident num_union id_uni q102d q102f q103 q105 q107 year 
sort id_uni year
merge  id_uni year using "net_conj.dta"
sort  id_uni year
drop _merge id_uni 
drop if num_union==.


/*recoding  country of residence for partner before the first migration*/
generate loc_conj=country
replace  loc_conj=q107 if loc_conj==. 
label value loc_conj COUNTRY
drop country q107

/*reshaping the database because of overlapping (num_union solution)*/
tostring year, generate(y)
generate id=ident+y
drop y
bysort id: egen nbu=count(num_union) 
label variable nbu "Number of unions"
generate num_uni=num_union
label variable num_uni "Number of the union"

sort ident num_union 
reshape wide q* loc_conj num_uni, i(id) j(num_union)
order ident year, first
drop id
sort ident year
save "loc_conj.dta"

* merge loc_conj.dta & loc_resp.dta*
use "loc_resp.dta", clear
sort ident year 
merge 1:1 ident year using "loc_conj.dta"
drop _merge
drop if age<14 
drop q904* q102*
save "base_analyse.dta", replace


************************
* B.ANALYSIS VARIABLES *
************************

/** B1. TVC MARITAL STATUS **/

/* Modifications for q103 & q105 */
* q103
for num 1/5: replace q103X=q103X[_n-1] if num_uniX==. & ident[_n]==ident[_n-1]
for num 1/5: replace q103X=. if num_uniX!=. 
* q105 
for num 1/5: replace q105X=. if q105X>year & num_uniX!=. & ident[_n]==ident[_n+1]
for num 1/5: replace q105X=1 if q105X!=.
label define Q105 1 "Marriage", modify
for num 1/5: label value q105X Q105

/* marital status */

* Dummy for being alone and never in partnership
generate C=1 if num_uni1==. & q1031==.
replace C=0 if C==.
label variable C "Alone, never in partnership =1"

*  Dummy for widowing 
for num 1/5: generate V_X=1 if q103X==2 
egen v=rsum(V_*)
generate V=1 if v>0 & v<.
replace V=0 if V==.
drop V_* v
label variable V "Widowed =1"

*  Dummy for separation
for num 1/5: generate D_X=1 if q103X==1
egen d=rsum(D_*)
generate D=1 if d>0 & d<.
replace D=0 if D==.
drop D_* d
label variable D "Divorced or separated =1"

* Dummy for free union
for num 1/5: generate U_X=1 if num_uniX!=. & q105X==. 
egen u=rsum(U_*)
generate U=1 if u>0 & u<.
replace U=0 if U==.
drop U_* u
label variable U "Partnership, not married=1"

* Dummy for marriage
for num 1/5: generate M_X=1 if num_uniX!=. & q105X!=. 
egen m=rsum(M_*)
generate M=1 if m>0 & m<.
replace M=0 if M==.
drop M_* m
label variable M "Married=1"

* Time varying covariate for marital status
generate marital=.
order marital, after(M)
replace marital=1 if C==1
replace marital=2 if D==1 & nbu==.
replace marital=3 if V==1 & nbu==.
replace marital=4 if U==1 & nbu==1
replace marital=5 if M==1 & nbu==1
replace marital=6 if U==1 & nbu>1 & nbu<. & M==0
replace marital=7 if M==1 & nbu>1 & nbu<.

label define mar_stat 1 "Alone, never in union", replace
label define mar_stat 2 "Alone, separated", modify
label define mar_stat 3 "Alone, widowed", modify
label define mar_stat 4 "Monogamy, informal union", modify
label define mar_stat 5 "Monogamy, married", modify
label define mar_stat 6 "Polygamy, only informal unions", modify
label define mar_stat 7 "Polygamy, at least one marriage", modify
label value marital mar_stat

tab marital
save "base_analyse.dta", replace

/** B2. TVC MARITAL STATUS & LOCALISATION*/

/* countries comparaison */
             generate uni_loc=1 if loc_resp==loc_conj1 & nbu>0 & nbu<.
for num 2/5: replace  uni_loc=1 if loc_resp==loc_conjX & nbu>0 & nbu<. & loc_conjX!=.
for num 1/5: replace  uni_loc=0 if loc_resp!=loc_conjX & nbu>0 & nbu<. & loc_conjX!=.
label variable uni_loc "Respondant & partner(s) in the same country = 1"

generate uni=1 if nbu!=.
label variable uni "Respondant in union = 1"

save "base_analyse.dta", replace

/* B21. Example with one respondant (E1)*/ 
keep if ident=="E1" 
keep ident year age uni_loc loc_resp loc_conj1 uni
save "E1.dta", replace

* Number of years in the same country & in union
sort ident year
by ident: generate cuni=sum(uni) if uni==1
by ident: generate cuni_loc=sum(uni_loc) if uni==1
sort ident year

*TVC
generate trans=0 if uni==.
replace  trans1=1 if uni_loc==0 
replace  trans1=2 if uni_loc==1 & cuni>cuni_loc 
replace  trans1=3 if uni_loc==1 & cuni==cuni_loc 
label variable trans "Marital/Geographical situation each year" 

label define TRANS 0 "No partner/spouse", modify 
label define TRANS 1 "Transnational", modify
label define TRANS 2 "Reunified", modify
label define TRANS 3 "Always unified", modify
label value trans TRANS
tabulate trans
save "E1.dta"


/* B22. Synthesis variable for all the union & years */ 

use "base_analyse.dta", clear

* suni_id: id for each union's structure 
for num 1/5: tostring num_uniX, generate (x_X)
egen suni_id=concat(x_*)
replace suni_id="" if suni_id=="....."
drop x_*
order suni_id, after(marital)

*tvc
sort ident suni_id year
by ident suni_id: generate cuni=sum(uni) if uni==1
by ident suni_id: generate cuni_loc=sum(uni_loc) if uni==1
sort ident year

generate trans=0 if nbu==.
replace trans=1 if uni_loc==0 
replace trans=2 if uni_loc==1 & cuni>cuni_loc  
replace trans=3 if uni_loc==1 & cuni==cuni_loc 
label variable trans "Marital/Geographical situation each year" 

label define TRANS 0 "No partner/spouse", modify 
label define TRANS 1 "Transnational", modify
label define TRANS 2 "Reunified", modify
label define TRANS 3 "Always unified", modify
label value trans TRANS

tabulate trans

* Same variable with some details for marital status 
generate trans2=0 if trans==0 & C==1 
 replace trans2=1 if trans==0 & (D==1 | V==1) & nbu==.
 replace trans2=2 if trans==1 
 replace trans2=3 if trans==2
 replace trans2=4 if trans==3

label define TRANS2 0 "Never in union", modify
label define TRANS2 1 "Separated or widowed", modify
label define TRANS2 2 "Transnational", modify
label define TRANS2 3 "Reunified", modify
label define TRANS2 4 "Always unified", modify
label value  trans2 TRANS2

tabulate trans2

save"transtot.dta"


